//
//  AccountViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 29.05.22.
//

import UIKit
import JNGradientLabel  // .package(url: "https://github.com/SomeRandomiOSDev/JNGradientLabel.git", from: "1.0.0")

class AccountDetailsViewController: UIViewController, UIViewControllerTransitioningDelegate {

    
    @IBOutlet weak var topBarLabel: JNGradientLabel!
    
    @IBOutlet var LightBankingGiroAccountTopBarLabel: UILabel!
    
    @IBOutlet weak var totalAmountLabel_L: UILabel!
    //@IBOutlet weak var totalAmountLabel: UILabel!
    @IBOutlet weak var totalAmountLabel_R: UILabel!
    
    @IBOutlet var transactionStackView: UIStackView!
    
    //@IBOutlet weak var totalAmountJNGradientLabel: JNGradientLabel!
    // Tranaction 01
    @IBOutlet weak var transactionLabel01L: UILabel!
    @IBOutlet weak var transactionLabel01R: UILabel!
    @IBOutlet weak var transaction01View: UIView!
    
    // Tranaction 02
    @IBOutlet weak var transactionView02: UIView!
    @IBOutlet weak var transactionLabel02L: UILabel!
    @IBOutlet var transactionAmount02Label: UILabel!
    
    
    // Tranaction 03
    @IBOutlet weak var transactionView03: UIView!
    @IBOutlet weak var transactionLabel03L: UILabel!
    @IBOutlet var transactionAmount03Label: UILabel!
    
    
    // needed for refresh feature
    @IBOutlet weak var scrool: UIScrollView!
    
    // Tranaction 04
    @IBOutlet weak var transactionView04: UIView!
    @IBOutlet weak var transactionLabel04L: UILabel!
    @IBOutlet var transactionAmount04Label: UILabel!
    

    // Tranaction 05
    @IBOutlet weak var transactionView05: UIView!
    @IBOutlet weak var transactionLabel05L: UILabel!
    @IBOutlet var transactionAmount05Label: UILabel!
    
    
    // Tranaction 06
    @IBOutlet var transaction06View: UIView!
    @IBOutlet var transactionRecipient06Label: UILabel!
    @IBOutlet var transactionAmount06Label: UILabel!
    
    // Tranaction 07
    @IBOutlet var transaction07View: UIView!
    @IBOutlet var transactionRecipient07Label: UILabel!
    @IBOutlet var transactionAmount07Label: UILabel!
    
    // Tranaction 08
    @IBOutlet var transaction08View: UIView!
    @IBOutlet var transactionRecipient08Label: UILabel!
    @IBOutlet var transactionAmount08Label: UILabel!
    
    // Tranaction 09
    @IBOutlet var transaction09View: UIView!
    @IBOutlet var transactionRecipient09Label: UILabel!
    @IBOutlet var transactionAmount09Label: UILabel!
    
    // Tranaction 10
    @IBOutlet var transaction10View: UIView!
    @IBOutlet var transactionRecipient10Label: UILabel!
    @IBOutlet var transactionAmount10Label: UILabel!
    
    // Tranaction 11
    @IBOutlet var transaction11View: UIView!
    @IBOutlet var transactionRecipient11Label: UILabel!
    @IBOutlet var transactionAmount11Label: UILabel!
    
    // Tranaction 12
    @IBOutlet var transaction12View: UIView!
    @IBOutlet var transactionRecipient12Label: UILabel!
    @IBOutlet var transactionAmount12Label: UILabel!
    
    
    // User Transaction (hidden by default)
    @IBOutlet var transactionUserView: UIView!
    @IBOutlet var transactionRecipientLabel: UILabel!
    @IBOutlet var transactionAmountLabel: UILabel!
    
    
    
    var refreshControl = UIRefreshControl()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : UIColor.white,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        LightBankingGiroAccountTopBarLabel.font = Fonts.mediumFontWithSize(size: 18)
        
        //https://stackoverflow.com/questions/54730638/how-to-add-pull-to-refresh-controller-to-scrollview
        // Add refresh control for the Home page scroll view.
                self.refreshControl.tintColor = UIColor.black
                self.refreshControl.attributedTitle = NSAttributedString(string: "Ziehen zum aktualisieren") // Pull to refresh
                self.refreshControl.addTarget(self, action: #selector(refresh(sender:)), for: UIControl.Event.valueChanged)
                self.scrool.isScrollEnabled = true
                self.scrool.alwaysBounceVertical = true
                scrool.addSubview(refreshControl)
        
        //let gradientColors: [UIColor]    = [UIColor(red: 34.0/255.0, green: 147.0/255.0, blue: 250.0/255.0, alpha: 1.0), UIColor(red: 2.0/255.0, green: 98.0/255.0, blue: 234.0/255.0, alpha: 1.0)]
        
        let gradientColors: [UIColor]    = [UIColor(red: 47.0/255.0, green: 67.0/255.0, blue: 99.0/255.0, alpha: 1.0), UIColor(red: 67/255.0, green: 114.0/255.0, blue: 196.0/255.0, alpha: 1.0)]
        let gradientlocations: [CGFloat] = [1.0, 0.0]
        
        topBarLabel.textColor = .white
        topBarLabel.textGradientLocation = .background
        topBarLabel.setAxialGradientParameters(startPoint: CGPoint(x: 0.0, y: 0.0),
                                                                endPoint: CGPoint(x: 1.0, y: 1.0),
                                                                colors: gradientColors,
                                                                locations: gradientlocations)
        
        //backButton.tintColor = UIColor.white
        self.navigationItem.backButtonTitle = "hohoho"
        
        
        
        //let gradientColorsTotalAmount: [UIColor]    = [UIColor(red: 42.0/255.0, green: 44.0/255.0, blue: 50.0/255.0, alpha: 1.0), UIColor(red: 48.0/255.0, green: 52.0/255.0, blue: 58.0/255.0, alpha: 1.0)]
        
        //totalAmountJNGradientLabel.text = "Gesamt:\t\t\t\t +3.582,64 €"
        //totalAmountJNGradientLabel.textColor = .white
        //totalAmountJNGradientLabel.font = UIFont.systemFont(ofSize: 17)
        //totalAmountJNGradientLabel.textGradientLocation = .background
        //totalAmountJNGradientLabel.layer.cornerRadius = 15.0
        //totalAmountJNGradientLabel.setAxialGradientParameters(startPoint: CGPoint(x: 0.0, y: 0.0),
        //                                                        endPoint: CGPoint(x: 1.0, y: 1.0),
        //                                                        colors: gradientColorsTotalAmount,
        //                                                        locations: gradientlocations)
        //
        
        //totalAmountLabel.layer.masksToBounds = true
        //totalAmountLabel.layer.cornerRadius = 10
        
        //transactionLabel01L.numberOfLines = 0
        //transactionLabel01L.lineBreakMode = .byTruncatingTail
        //let amountPurpose = NSMutableAttributedString.init(string: "Gesamt:")
        
        //amountPurpose.setAttributes([NSAttributedString.Key.font: UIFont.systemFont(ofSize: 17),
                                    //NSAttributedString.Key.foregroundColor: UIColor.black],
                                   //range: NSMakeRange(0, 6))
        
        
        //self.title = "DE68350314842368053570"
        let search = UISearchController(searchResultsController: nil)
        search.searchResultsUpdater = self
        search.searchBar.placeholder = "Umsatzsuche"
        self.navigationItem.searchController = search
        
        
       // let transaction01LPurpose = NSMutableAttributedString(string: "Internet\n", attributes: [NSAttributedString.Key.font: UIFont.systemFont(ofSize: 17)])
        
        //transaction01LPurpose.append(NSAttributedString(string: "Internet Provider", attributes: [NSAttributedString.Key.font: UIFont.boldSystemFont(ofSize: 14), NSAttributedString.Key.foregroundColor: UIColor.white]))
        
        /*
        // calculate giro account amount (based on whether user transaction took place or not
        var amountGiroAccountString : String = ""
        let defaults = UserDefaults.standard
        if UserDefaults.standard.object(forKey: "userTransactionAmount") != nil {
            let userTransactionAmountDouble = defaults.double(forKey: "userTransactionAmount")
            
            amountGiroAccountString = String((amountGiroAccountPublic - userTransactionAmountDouble)).replacingOccurrences(of: ",", with: ".")
        } else {
            amountGiroAccountString = String(amountGiroAccountPublic).replacingOccurrences(of: ".", with: ",") + " €"
        }
        */
        
        
        // style top total bank balance label and number
        totalAmountLabel_L.font = Fonts.heavyFontWithSize(size: 20)
        
        totalAmountLabel_R.font = Fonts.heavyFontWithSize(size: 20)
         
        // calculate giro account amount (based on whether user transaction took place or not
        // User Transaction did not took place
        var amountGiroAccountString : String = ""
        var sumGiroAccount : Float = 0.00
        let defaults = UserDefaults.standard
        if defaults.object(forKey: "amountGiroAccount") != nil {
            let amountGiroAccountAfterTransaction = defaults.float(forKey: "amountGiroAccount")
            //sumGiroAccount = amountGiroAccountPublic-userTransactionAmountDouble
            sumGiroAccount = amountGiroAccountAfterTransaction
            print("amountGiroAccountPublic:")
            print(amountGiroAccountPublic)
            print("userTransactionAmountDouble:")
            print(amountGiroAccountAfterTransaction)
            
        } else { // User transaction done
            sumGiroAccount = amountGiroAccountPublic
        }
        
        amountGiroAccountString = String(format: "%.2f", sumGiroAccount).replacingOccurrences(of: ".", with: ",") + " €"
        
        Utilities.addDotsToBankBalance(sumFloat: sumGiroAccount ,sumString: &amountGiroAccountString)
        
        totalAmountLabel_R.text = amountGiroAccountString
        
        /*
        if amountGiroAccountPublic >= 1000 {
            amountGiroAccountString.insert(".", at: amountGiroAccountString.index(amountGiroAccountString.startIndex, offsetBy: 1))
        } else if amountGiroAccountPublic >= 10000 {
            amountGiroAccountString.insert(".", at: amountGiroAccountString.index(amountGiroAccountString.startIndex, offsetBy: 2))
        } else if amountGiroAccountPublic >= 100000 {
            amountGiroAccountString.insert(".", at: amountGiroAccountString.index(amountGiroAccountString.startIndex, offsetBy: 3))
        }
        */
        
        
        // Tranaction 01
        //transaction01View.layer.borderWidth = 1.0
        transaction01View.layer.cornerRadius = 5
        transaction01View.layer.backgroundColor = UIColor.white.cgColor
        //transaction01View.layer.borderColor = UIColor(red: 137.0/255.0, green: 140.0/255.0, blue: 150.0/255.0, alpha: 1.0).cgColor

        
        transactionLabel01L.numberOfLines = 0
        transactionLabel01L.lineBreakMode = .byTruncatingTail
        
        transactionLabel01L.font = Fonts.lightFontWithSize(size: 13)
        let transaction01LPurpose = NSMutableAttributedString.init(string: "Internet Provider DSLForMe\nSEPA Folgelastschrift")
        
        
        transaction01LPurpose.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 15),
                                    NSAttributedString.Key.foregroundColor: UIColor.black],
                                   range: NSMakeRange(0, 26))
        
        transactionLabel01L.attributedText = transaction01LPurpose
        
        transactionLabel01R.font = Fonts.mediumFontWithSize(size: 18)
        

        // Tranaction 02
        //transactionView02.layer.borderWidth = 1.0
        //transactionView02.layer.borderColor = UIColor(red: 137.0/255.0, green: 140.0/255.0, blue: 150.0/255.0, alpha: 1.0).cgColor
        transactionView02.layer.cornerRadius = 5
        transactionView02.layer.backgroundColor = UIColor.white.cgColor

        
        transactionLabel02L.numberOfLines = 0
        transactionLabel02L.lineBreakMode = .byTruncatingTail
        
        transactionLabel02L.font = Fonts.lightFontWithSize(size: 13)
        let transaction02LPurpose = NSMutableAttributedString.init(string: "Parkhaus-Süd\nSEPA Lastschrift")
        
        
        transaction02LPurpose.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 15),
                                    NSAttributedString.Key.foregroundColor: UIColor.black],
                                   range: NSMakeRange(0, 12))
        
        transactionLabel02L.attributedText = transaction02LPurpose
        
        transactionAmount02Label.font = Fonts.mediumFontWithSize(size: 18)
        
        
        /*### Transaction 03 ###*/
        transactionView03.layer.cornerRadius = 5
        transactionView03.layer.backgroundColor = UIColor.white.cgColor
        
        transactionLabel03L.numberOfLines = 0
        transactionLabel03L.lineBreakMode = .byTruncatingTail
        
        transactionLabel03L.font = Fonts.lightFontWithSize(size: 13)
        let transaction03LPurpose = NSMutableAttributedString.init(string: "Kontoführung\nGebühren Kontoführung")
        
        transaction03LPurpose.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 15),
                                    NSAttributedString.Key.foregroundColor: UIColor.black],
                                   range: NSMakeRange(0, 12))
        transactionLabel03L.attributedText = transaction03LPurpose
        
        transactionAmount03Label.font = Fonts.mediumFontWithSize(size: 18)
        
        
        /*### Transaction 04 ###*/
        transactionView04.layer.cornerRadius = 5
        transactionView04.layer.backgroundColor = UIColor.white.cgColor

        transactionLabel04L.numberOfLines = 0
        transactionLabel04L.lineBreakMode = .byTruncatingTail
        
        transactionLabel04L.font = Fonts.lightFontWithSize(size: 13)
        let transaction04LPurpose = NSMutableAttributedString.init(string: "My Workspace AG\nGehalteingang")
        transaction04LPurpose.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 15),
                                    NSAttributedString.Key.foregroundColor: UIColor.black],
                                   range: NSMakeRange(0, 16))
        transactionLabel04L.attributedText = transaction04LPurpose
        
        transactionAmount04Label.font = Fonts.lightFontWithSize(size: 18)
        transactionAmount04Label.textColor = Colors.greenColor
        
        
        /*### Transaction 05 ###*/
        transactionView05.layer.cornerRadius = 5
        transactionView05.layer.backgroundColor = UIColor.white.cgColor
        
        transactionLabel05L.numberOfLines = 0
        transactionLabel05L.lineBreakMode = .byTruncatingTail
        
        transactionLabel05L.font = Fonts.lightFontWithSize(size: 13)
        let transaction05LPurpose = NSMutableAttributedString.init(string: "Shopping-Center\nSEPA Lastschrift")
        transaction05LPurpose.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 15),
                                    NSAttributedString.Key.foregroundColor: UIColor.black],
                                   range: NSMakeRange(0, 15))
        transactionLabel05L.attributedText = transaction05LPurpose
        
        transactionAmount05Label.font = Fonts.mediumFontWithSize(size: 18)
        

        /*### Transaction 06 ###*/
        transaction06View.layer.cornerRadius = 5
        transaction06View.layer.backgroundColor = UIColor.white.cgColor
        
        transactionRecipient06Label.numberOfLines = 0
        transactionRecipient06Label.lineBreakMode = .byTruncatingTail
        
        transactionRecipient06Label.font = Fonts.lightFontWithSize(size: 13)
        let transactionRecipient06String = NSMutableAttributedString.init(string: "LightBanking\nSEPA Folgelastschrift")
        transactionRecipient06String.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 15),
                                    NSAttributedString.Key.foregroundColor: UIColor.black],
                                   range: NSMakeRange(0, 12))
        transactionRecipient06Label.attributedText = transactionRecipient06String
        
        transactionAmount06Label.font = Fonts.mediumFontWithSize(size: 18)
        
        
        /*### Transaction 07 ###*/
        transaction07View.layer.cornerRadius = 5
        transaction07View.layer.backgroundColor = UIColor.white.cgColor
        
        transactionRecipient07Label.numberOfLines = 0
        transactionRecipient07Label.lineBreakMode = .byTruncatingTail
        
        transactionRecipient07Label.font = Fonts.lightFontWithSize(size: 13)
        let transactionRecipient07String = NSMutableAttributedString.init(string: "Restaurant\nKartenzahlung")
        transactionRecipient07String.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 15),
                                    NSAttributedString.Key.foregroundColor: UIColor.black],
                                   range: NSMakeRange(0, 10))
        transactionRecipient07Label.attributedText = transactionRecipient07String
        
        transactionAmount07Label.font = Fonts.mediumFontWithSize(size: 18)
        
        
        /*### Transaction 08 ###*/
        transaction08View.layer.cornerRadius = 5
        transaction08View.layer.backgroundColor = UIColor.white.cgColor
        
        transactionRecipient08Label.numberOfLines = 0
        transactionRecipient08Label.lineBreakMode = .byTruncatingTail
        
        transactionRecipient08Label.font = Fonts.lightFontWithSize(size: 13)
        let transactionRecipient08String = NSMutableAttributedString.init(string: "Andrea Berghausen\nSEPA Überweisung")
        transactionRecipient08String.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 15),
                                    NSAttributedString.Key.foregroundColor: UIColor.black],
                                   range: NSMakeRange(0, 17))
        transactionRecipient08Label.attributedText = transactionRecipient08String
        
        transactionAmount08Label.font = Fonts.mediumFontWithSize(size: 18)
        
        
        /*### Transaction 09 ###*/
        transaction09View.layer.cornerRadius = 5
        transaction09View.layer.backgroundColor = UIColor.white.cgColor
        
        transactionRecipient09Label.numberOfLines = 0
        transactionRecipient09Label.lineBreakMode = .byTruncatingTail
        
        transactionRecipient09Label.font = Fonts.lightFontWithSize(size: 13)
        let transactionRecipient09String = NSMutableAttributedString.init(string: "LightBanking Tagesgeldkonto\nSEPA Überweisung (Dauerauftrag)")
        transactionRecipient09String.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 15),
                                    NSAttributedString.Key.foregroundColor: UIColor.black],
                                   range: NSMakeRange(0, 27))
        transactionRecipient09Label.attributedText = transactionRecipient09String
        
        transactionAmount09Label.font = Fonts.mediumFontWithSize(size: 18)
        
        
        /*### Transaction 10 ###*/
        transaction10View.layer.cornerRadius = 5
        transaction10View.layer.backgroundColor = UIColor.white.cgColor
        
        transactionRecipient10Label.numberOfLines = 0
        transactionRecipient10Label.lineBreakMode = .byTruncatingTail
        
        transactionRecipient10Label.font = Fonts.lightFontWithSize(size: 13)
        let transactionRecipient10String = NSMutableAttributedString.init(string: "Einkaufszentrum\nSEPA Lastschrift")
        transactionRecipient10String.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 15),
                                    NSAttributedString.Key.foregroundColor: UIColor.black],
                                   range: NSMakeRange(0, 15))
        transactionRecipient10Label.attributedText = transactionRecipient10String
        
        transactionAmount10Label.font = Fonts.mediumFontWithSize(size: 18)
        
        
        /*### Transaction 11 ###*/
        transaction11View.layer.cornerRadius = 5
        transaction11View.layer.backgroundColor = UIColor.white.cgColor
        
        transactionRecipient11Label.numberOfLines = 0
        transactionRecipient11Label.lineBreakMode = .byTruncatingTail
        
        transactionRecipient11Label.font = Fonts.lightFontWithSize(size: 13)
        let transactionRecipient11String = NSMutableAttributedString.init(string: "Miete Wohnung\nSEPA Folgelastschrift")
        transactionRecipient11String.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 15),
                                    NSAttributedString.Key.foregroundColor: UIColor.black],
                                   range: NSMakeRange(0, 13))
        transactionRecipient11Label.attributedText = transactionRecipient11String
        
        transactionAmount11Label.font = Fonts.mediumFontWithSize(size: 18)
        
        
        /*### Transaction 12 ###*/
        transaction12View.layer.cornerRadius = 5
        transaction12View.layer.backgroundColor = UIColor.white.cgColor
        
        transactionRecipient12Label.numberOfLines = 0
        transactionRecipient12Label.lineBreakMode = .byTruncatingTail
        
        transactionRecipient12Label.font = Fonts.lightFontWithSize(size: 13)
        let transactionRecipient12String = NSMutableAttributedString.init(string: "Fitness Studio BeFit\nSEPA Folgelastschrift")
        transactionRecipient12String.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 15),
                                    NSAttributedString.Key.foregroundColor: UIColor.black],
                                   range: NSMakeRange(0, 20))
        transactionRecipient12Label.attributedText = transactionRecipient12String
        
        transactionAmount12Label.font = Fonts.mediumFontWithSize(size: 18)
        
        /*### User Transaction ###*/
        transactionAmountLabel.font = Fonts.mediumFontWithSize(size: 18)
        
        transactionUserView.isHidden = true
        if UserDefaults.standard.object(forKey: "TransactionShowInGiroAccount") != nil {
            let defaults = UserDefaults.standard
            let transactionShowInGiroAccount = defaults.bool(forKey: "TransactionShowInGiroAccount")
          
            if transactionShowInGiroAccount {
                transactionUserView.isHidden = false
                
                transactionUserView.layer.cornerRadius = 5
                transactionUserView.layer.backgroundColor = UIColor.white.cgColor
                
                transactionRecipientLabel.text = defaults.string(forKey: "UserTransactionRecipient") ?? ""
                
                var transactionSum : String = String(defaults.float(forKey: "userTransactionAmount")).replacingOccurrences(of: ".", with: ",")

                if !Utilities.numberFollowedByDotAndExactTwoDigits(transactionSum) {
                    transactionSum = transactionSum + "0"
                }
                
                if transactionSum.count >= 7 {
                    transactionSum.insert(".", at: (transactionSum.index(transactionSum.startIndex, offsetBy: 1)))
                }
                transactionAmountLabel.text = " - " + transactionSum + " €"
                
                
                transactionRecipientLabel.numberOfLines = 0
                transactionRecipientLabel.lineBreakMode = .byTruncatingTail
                
                transactionRecipientLabel.font = Fonts.lightFontWithSize(size: 13)
                let transactionRecipientSubString = defaults.string(forKey: "UserTransactionRecipient") ?? ""
                let transactionUserRecipientString = NSMutableAttributedString.init(string: transactionRecipientSubString+"\nSEPA Überweisung")
                transactionUserRecipientString.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 15),
                                            NSAttributedString.Key.foregroundColor: UIColor.black],
                                                             range: NSMakeRange(0, transactionRecipientSubString.count))
                transactionRecipientLabel.attributedText = transactionUserRecipientString
                
                
                
            } else {
                print("Something went wrong receiving user default's data from device")
            }
        }
        
        let guestureRecognizerStandardTransaction = UITapGestureRecognizer(target: self, action: #selector(detailsUserTransaction(_:)))
        transactionUserView.isUserInteractionEnabled = true
        transactionUserView.addGestureRecognizer(guestureRecognizerStandardTransaction)
        
        
    }
    
    @objc func detailsUserTransaction(_ sender: Any) {
        if #available(iOS 15.0, *) {
        let nc = self.storyboard?.instantiateViewController(withIdentifier: "DetailsUserTransactionNC") as! UINavigationController
        
        
            if let presentationController = nc.presentationController as? UISheetPresentationController {
                
                presentationController.detents = [.medium()]
            }
            self.present(nc, animated: true)
            
        } else {
            let storyboard = UIStoryboard(name: "Main", bundle: nil)
                    let viewController = storyboard.instantiateViewController(withIdentifier: "DetailsUserTransactionVC")
            viewController.modalPresentationStyle = .custom
            viewController.transitioningDelegate = self
            self.present(viewController, animated: true, completion: nil)
        }
        
        
    }
    
    
    @IBAction func backButton(_ sender: Any) {
        let tabBarController = self.storyboard?.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
        
        tabBarController.modalPresentationStyle = .fullScreen
        tabBarController.modalTransitionStyle = .crossDissolve
        
        present(tabBarController, animated: true)

    }
    
    // https://stackoverflow.com/questions/54730638/how-to-add-pull-to-refresh-controller-to-scrollview
    @objc func refresh(sender:AnyObject) {
            
        let secondsAnimationDelay = 0.7
        DispatchQueue.main.asyncAfter(deadline: .now() + secondsAnimationDelay) {
            // Put your code which should be executed with a delay here
            
            // Code to refresh table view
            self.refreshControl.endRefreshing()
        }

        
        let seconds = 1.0
        DispatchQueue.main.asyncAfter(deadline: .now() + seconds) {
            // Put your code which should be executed with a delay here
            /* DEACTIVATED BELOW; PLEASE CHANGE IF WANTED!!!*/
            //self.totalAmountLabel_R.text = "100.000 €"
        }

        }
}

    extension AccountDetailsViewController: UISearchResultsUpdating{
        func updateSearchResults(for searchController: UISearchController) {
            print(#function)
            print(searchController.searchBar.text)
        }
    }



